package model.passes;

import java.util.HashMap;
import java.util.Set;

import model.Pass;

/**
 * This implementation of {@link Pass} interface provides a limited number of
 * possible entries for each attraction
 * 
 * @author simone
 *
 */
public class BPass implements Pass {

	private HashMap<String, Integer> entries = new HashMap<String, Integer>();

	/**
	 * Create a new istance of this class
	 * 
	 * @param keySet: the whole set of attractions (identified by a ID)
	 */
	public BPass(Set<String> keySet) {
		initializeEntriesMap(keySet);
	}

	private void initializeEntriesMap(Set<String> keySet) {
		for (String ID : keySet) {
			this.entries.put(ID, 2);
		}
	}

	@Override
	/*
	 * (non-Javadoc)
	 * 
	 * @see model.Pass#getEntriesLeft(java.lang.String)
	 */
	public int getEntriesLeft(String attractionID) {
		return this.entries.get(attractionID);
	}

	@Override
	/*
	 * (non-Javadoc)
	 * 
	 * @see model.Pass#used(java.lang.String)
	 */
	public void used(String attractionID) {
		this.entries.put(attractionID, this.entries.get(attractionID) - 1);
	}

}
